 ; Ŀ
 ;   Trg - ground a tray.                                                  
 ;   Copyright 2005, 2006 by Rocket Software Ltd.                          
 ;   There are still very few network-ready projectile weapons.            
 ; 
 (DEFUN C:TRG (/ *error* osmo clay dimscl pa enamel pb angg radd pacut1 pacut2
                                                          enaml2 arc1 arc2 typ)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
  (setq clay (getvar "clayer"))
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (setvar "clayer" clay)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get the scale, depending on which space we are in and other things.   
 ; 
  (if misps
      (setq dimscl (misps))
      (setq dimscl (getvar "dimscale")))
 ; Ŀ
 ;   Make the grounding layer.                                             
 ; 
  (setq lanam "ground")
  (if c:malaya (malaya lanam))
 ; Ŀ
 ;   The grounding layer may be called Ground, or Ground may be a          
 ;   variable which contains a layer name, so check.                       
 ; 
  (if (= (type (setq lamp (eval (read lanam)))) 'STR)
      (setq lanam lamp))
  (setvar "osmode" 512)           ; nearest
  (setq pa (getpoint "Ground Line:"))
  (setq enamel (car (nentselp pa)))
 ; Ŀ
 ;   Put the line on the ground layer.                                     
 ; 
  (command ".change" enamel "" "p" "la" lanam "")
  (setvar "osmode" 128)           ; perpendicular
  (setq pb (getpoint pa "\nTray:"))
  (setvar "osmode" 0)
  (setq angg (angle pa pb))
  (setq radd (distance pa pb))
  (setq pacut1 (polar pa (+ angg (/ pi 2)) radd))
  (setq pacut2 (polar pa (- angg (/ pi 2)) radd))
  (command "break" (list enamel pacut1) pacut2)
  (setq enaml2 (entlast))
  (command "arc" pb "c" (polar pb (- angg (/ pi 2)) radd) pacut2)
  (setq arc1 (entlast))
  (command "arc" pacut1 "c" (polar pb (+ angg (/ pi 2)) radd) pb)
  (setq arc2 (entlast))
  (command ".insert" "groundcon" pb dimscl "" 0)
  (setq typ (cdr (assoc 0 (entget enamel))))
  (if (or (= typ "POLYLINE") (= typ "LWPOLYLINE"))
      (command ".pedit" enamel "j" enaml2 arc1 arc2 "" "")
      (command ".pedit" enamel "y" "j" enaml2 arc1 arc2 "" ""))
  (*error*)
 (princ))